/*jshint esversion: 6 */

define([
	"src/utils", "lodash", "immutable",
	"lib/tasks/dofs", "src/math/Mat3", "src/math/Vec2",
	"lib/tasks/internal",
    "lib/dev/config"
	],
function(
	utils, lodash, immutable,
	dofs, mat3, vec2,
	internal,
     config
) {

"use strict";


/*============================================================================
	Helpers
============================================================================*/

function getAnchorFrameRelativeToLayer (handle, result0) {
	var layer = handle.getWarperLayer(),
		tree = layer.getHandleTreeArray(),
		handleRef = tree.getHandleRef(handle),
		path = internal.getKeyPath(layer, "value");

	var lomNow = path.layer.tomNow.getIn(path.key);

	return internal.getAnchorFrame(tree, lomNow, handleRef, null, result0);
}



function getTrackItemSdkLayer (handle) {
	// FIXME: convulated way of getting TrackItem's skd layer.
	return handle.getPuppet().getTrackItem().getSdkLayer();
}

const kAccumulator = "kMoveFrameByAccumulator";

function setMoveFrameByAccumulator (sdkLayer, value) {
	return sdkLayer.setSharedFrameData(kAccumulator, value);
}

function getMoveFrameByAccumulator (sdkLayer) {
	var accumulator = sdkLayer.getSharedFrameData(kAccumulator);

	// make one when absent
	if (!accumulator) {
		accumulator = {};
		setMoveFrameByAccumulator(sdkLayer, accumulator);
	}

	return accumulator;
}

function updateMoveFrameBy (sdkLayer, key, updater) {
	const accumulator = getMoveFrameByAccumulator(sdkLayer);
	accumulator[key] = updater(accumulator[key]);
	setMoveFrameByAccumulator(sdkLayer, accumulator);
}

function keyStringFromArray (array) {
	const kSep = "/";
	return array.join(kSep);
}

/*============================================================================
	API
============================================================================*/
/**
var moveTo = new task.moveTo({ x: 7, y: 9, angle: 90, sx : 1, ...});
var moveBy = new task.moveBy({ x: 3, y: -9, ....});

var parallel = new task.simultaneousGroup.of(moveTo, moveBy);
var parallel = new task.simultaneousGroup.from([moveTo, moveBy]);

var sequence = new task.sequentialGroup.of(moveTo, moveBy);
var sequence = new task.sequentialGroup.from([moveTo, moveBy]);

parallel.attachTask(moveTo);  // you can't remove it without a key
*/

var Handle = config.MutableTree.enabled ? 
{
	getFrame (handle, result0) {
		var layer = handle.getWarperLayer(),
			tree = layer.getHandleTreeArray(),
			handleRef = tree.getHandleRef(handle),
			path = internal.getKeyPath(layer, "value", handleRef, "matrix");

		var frame = path.layer.tomNow.getIn(path.key);

		return mat3.initWithArray(frame, result0);
	},
    
	getFrameRelativeToLayer (handle, result0) {
		var layer = handle.getWarperLayer(),
			tree = layer.getHandleTreeArray(),
			handleRef = tree.getHandleRef(handle),
			path = internal.getKeyPath(layer, "value");

		var lomNow = path.layer.tomNow.getIn(path.key);

		return internal.getHandleFrame(tree, lomNow, handleRef, null, result0);
	},


	convertLayerPoint (handle, pointLayer, result0) {
		var matAnchor_Layer = mat3();
		mat3.invert(getAnchorFrameRelativeToLayer(handle), matAnchor_Layer);
		return vec2.transformAffine(matAnchor_Layer, pointLayer, result0);
	},

	convertLayerFrame (handle, frameLayer, result0) {
		var matAnchor_Layer = mat3();
		mat3.invert(getAnchorFrameRelativeToLayer(handle), matAnchor_Layer);
		return mat3.multiply(matAnchor_Layer, frameLayer, result0);
	},

	setFrame (handle, value, type) {
		var layer = handle.getWarperLayer(),
			tree = layer.getHandleTreeArray(),
			handleRef = tree.getHandleRef(handle),
			path = internal.getKeyPath(layer, "value", handleRef);

		var	next = new dofs.Matrix({ type, matrix : mat3.from(value) });
		path.layer.tomNow.setIn(path.key, next);
	},

	// FIXME: support translation and linear types.
	moveFrameBy (handle, matMove) {
		const sdkLayerTrackItem = getTrackItemSdkLayer(handle),
			layer = handle.getWarperLayer(),
			handleRef = layer.getHandleTreeArray().getHandleRef(handle),
			keyPath = internal.getKeyPath(layer, "value", handleRef),
			keyArray = keyPath.key,
			keyString = keyStringFromArray(keyArray);

		updateMoveFrameBy(sdkLayerTrackItem, keyString, function (existing) {
			var value;
			if (existing) {
				value = mat3.multiply(existing.value, matMove);
			} else {
				value = mat3.from(matMove);
			}

			return { keyArray, value };
		});
	},

	attachTask (handle, task, weight) {
		var layerRoot = getTrackItemSdkLayer(handle).privateLayer,
			layer = handle.getWarperLayer(),
			layerId = layer.getStageId(),
			handleId = handle.getStageId();

		var item = { layer, handle, task, weight, duration : 0 },
			tag = task.tag();

		lodash.set(layerRoot[tag], [ layerId, "layer" ], layer);
		lodash.update(layerRoot[tag], [ layerId, handleId ], function (val) {
			if (val) {
				val.push(item);
			} else {
				val = [ item ];
			}
			return val;
		});
	},

	internal : {
		getMoveFrameByAccumulator,

		// FIXME: This may miss dragging of hinge and weld joints whose type is never free.
		// Another approach is to compare with (handle.getAutoAttribute() === type) but then you may not be able to drag Hinge/Weld joints.
		isDragged (handle) {
			const layer = handle.getWarperLayer(),
				tree = layer.getHandleTreeArray(),
				handleRef = tree.getHandleRef(handle),
				pathLom = internal.getKeyPath(layer, "value"),
				lom = pathLom.layer.tomNow.getIn(pathLom.key);

			const type = lom.getType(handleRef);

			return type < 3;
		},

		getMatrixDof (/*handle*/) {
			utils.assert(false, "NYI: Mutable Tree support for pending state changes.");
		},

		sameMatrixDof (/*handle, mdof*/) {
			utils.assert(false, "NYI: Mutable Tree support for pending state changes.");
		},

		hasPendingTasks (/*handle*/) {
			utils.assert(false, "NYI: Mutable Tree support for pending state changes.");
        }

	}
} :
{       // config.MutableTree.enabled FALSE clause -- to be removed soon

	getFrame (handle, result0) {
		var layer = handle.getWarperLayer(),
			tree = layer.getHandleTreeArray(),
			handleRef = tree.getHandleRef(handle),
			path = internal.getKeyPath(layer, "value", handleRef, "matrix");

		var frame = path.layer.tomNow.getIn(path.key);

		return mat3.initWithArray(frame, result0);
	},
/* FIXME: no clients yet.  test and use; or remove.
	getFrameRelativeToHandle (handleFrom, handleTo, result0) {
		var layer = handle.getWarperLayer(),
			tree = layer.getHandleTreeArray(),
			refFrom = tree.getHandleRef(handleFrom),
			refTo = tree.getHandleRef(handleTo),
			path = internal.getKeyPath(layer, "value");

		var lomNow = path.layer.tomNow.getIn(path.key);

		return internal.getHandleFrame(tree, lomNow, refFrom, refTo, result0);
	},
*/
	getFrameRelativeToLayer (handle, result0) {
		var layer = handle.getWarperLayer(),
			tree = layer.getHandleTreeArray(),
			handleRef = tree.getHandleRef(handle),
			path = internal.getKeyPath(layer, "value");

		var lomNow = path.layer.tomNow.getIn(path.key);

		return internal.getHandleFrame(tree, lomNow, handleRef, null, result0);
	},

	convertLayerPoint (handle, pointLayer, result0) {
		var matAnchor_Layer = mat3();
		mat3.invert(getAnchorFrameRelativeToLayer(handle), matAnchor_Layer);
		return vec2.transformAffine(matAnchor_Layer, pointLayer, result0);
	},

	convertLayerFrame (handle, frameLayer, result0) {
		var matAnchor_Layer = mat3();
		mat3.invert(getAnchorFrameRelativeToLayer(handle), matAnchor_Layer);
		return mat3.multiply(matAnchor_Layer, frameLayer, result0);
	},

	setFrame (handle, value, type) {
		var layer = handle.getWarperLayer(),
			tree = layer.getHandleTreeArray(),
			handleRef = tree.getHandleRef(handle),
			path = internal.getKeyPath(layer, "value", handleRef);

		var	next = new dofs.Matrix({ type, matrix : mat3.from(value) });
		path.layer.tomNext = path.layer.tomNext.setIn(path.key, next);
	},

	// FIXME: support translation and linear types.
	moveFrameBy (handle, matMove) {
		const sdkLayerTrackItem = getTrackItemSdkLayer(handle),
			layer = handle.getWarperLayer(),
			handleRef = layer.getHandleTreeArray().getHandleRef(handle),
			keyPath = internal.getKeyPath(layer, "value", handleRef),
			keyArray = keyPath.key,
			keyString = keyStringFromArray(keyArray);

		updateMoveFrameBy(sdkLayerTrackItem, keyString, function (existing) {
			var value;
			if (existing) {
				value = mat3.multiply(existing.value, matMove);
			} else {
				value = mat3.from(matMove);
			}

			return { keyArray, value };
		});
	},

	attachTask (handle, task, weight) {
		var layerRoot = getTrackItemSdkLayer(handle).privateLayer,
			layer = handle.getWarperLayer(),
			layerId = layer.getStageId(),
			handleId = handle.getStageId();

		var item = { layer, handle, task, weight, duration : 0 },
			tag = task.tag();

		lodash.set(layerRoot[tag], [ layerId, "layer" ], layer);
		lodash.update(layerRoot[tag], [ layerId, handleId ], function (val) {
			if (val) {
				val.push(item);
			} else {
				val = [ item ];
			}
			return val;
		});
	},

	internal : {
		getMoveFrameByAccumulator,

		// FIXME: This may miss dragging of hinge and weld joints whose type is never free.
		// Another approach is to compare with (handle.getAutoAttribute() === type) but then you may not be able to drag Hinge/Weld joints.
		isDragged (handle) {
			const layer = handle.getWarperLayer(),
				tree = layer.getHandleTreeArray(),
				handleRef = tree.getHandleRef(handle),
				path = internal.getKeyPath(layer, "value", handleRef, "type");

			const type = path.layer.tomNow.getIn(path.key);

			return type < 3;
		},

		getMatrixDof (handle) {
			var layer = handle.getWarperLayer(),
			tree = layer.getHandleTreeArray(),
			handleRef = tree.getHandleRef(handle),
			path = internal.getKeyPath(layer, "value", handleRef);

			return path.layer.tomNow.getIn(path.key);
		},

		sameMatrixDof (handle, mdof) {
			var layer = handle.getWarperLayer(),
			tree = layer.getHandleTreeArray(),
			handleRef = tree.getHandleRef(handle),
			path = internal.getKeyPath(layer, "value", handleRef);

			return path.layer.tomNext.getIn(path.key) === mdof;
		},

		hasPendingTasks (handle) {
            // FIXME: refactor when removing dead-code for "tLayerPostWarpTaskItems"
            const tag = "tLayerTaskItems";

            const layerTrack = getTrackItemSdkLayer(handle).privateLayer,
                layer = handle.getWarperLayer(),
                idLayer = layer.getStageId(),
                idHandle = handle.getStageId(),
                layerTasks = layerTrack[tag][idLayer];

            return !lodash.isUndefined(layerTasks) && !lodash.isUndefined(layerTasks[idHandle]);
        }
	}
};

return Handle;

}); // end define


